/**
 * @file global_ccu8.c
 * @date 2016-02-10
 *
 * NOTE:
 * This file is generated by DAVE. Any manual modification done to this file will be lost when the code is regenerated.
 *
 * @cond
 ***********************************************************************************************************************
 * GLOBAL_CCU8 v4.1.12 - Configures the global properties of CCU8x peripheral instance.
 *
 * Copyright (c) 2016, Infineon Technologies AG
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the
 * following conditions are met:
 *
 *   Redistributions of source code must retain the above copyright notice, this list of conditions and the  following
 *   disclaimer.
 *
 *   Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the
 *   following disclaimer in the documentation and/or other materials provided with the distribution.
 *
 *   Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote
 *   products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT  OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * To improve the quality of the software, users are encouraged to share modifications, enhancements or bug fixes
 * with Infineon Technologies AG (dave@infineon.com).
 ***********************************************************************************************************************
 *
 * Change History
 * --------------
 *
 * 2015-02-16:
 *     - Initial version<br>
 *
 * @endcond
 *
 */
/***********************************************************************************************************************
 * HEADER FILES
 **********************************************************************************************************************/

#include "global_ccu8.h"

/***********************************************************************************************************************
 * MACROS
 **********************************************************************************************************************/

/***********************************************************************************************************************
 * LOCAL DATA
 **********************************************************************************************************************/
 
/***********************************************************************************************************************
 * LOCAL ROUTINES
 **********************************************************************************************************************/

 /**********************************************************************************************************************
 * API IMPLEMENTATION
 **********************************************************************************************************************/
/* Returns the version of the GLOBAL_CCU8 APP. */
DAVE_APP_VERSION_t GLOBAL_CCU8_GetAppVersion(void)
{
  DAVE_APP_VERSION_t version;

  version.major = GLOBAL_CCU8_MAJOR_VERSION;
  version.minor = GLOBAL_CCU8_MINOR_VERSION;
  version.patch = GLOBAL_CCU8_PATCH_VERSION;

  return version;
}

/* Initializes the slice with the generated configuration */
GLOBAL_CCU8_STATUS_t GLOBAL_CCU8_Init(GLOBAL_CCU8_t* handle)
{
  XMC_ASSERT("GLOBAL_CCU8_Init:NULL handler", (NULL != handle));

  if (false == handle->is_initialized)
  {
    /* Enable CCU8 module */
    XMC_CCU8_Init(handle->module_ptr,handle->mcs_action);
    /* Start the prescaler */
    XMC_CCU8_StartPrescaler(handle->module_ptr);
    /* Restricts multiple initializations */
    handle->is_initialized = true;
  }

  return (GLOBAL_CCU8_STATUS_SUCCESS);
}
